<?php require_once 'views/head.php'; ?>

<style>
/* ==============================
   ADMIN DASHBOARD - MAIN.PHP
============================== */
:root {
	--ad-primary:    #6c63ff;
	--ad-success:    #10b981;
	--ad-warning:    #f59e0b;
	--ad-danger:     #f72585;
	--ad-info:       #4cc9f0;
	--ad-dark:       #0f0e17;
	--ad-card:       #1a1927;
	--ad-border:     rgba(255,255,255,0.08);
	--ad-text:       #fffffe;
	--ad-muted:      #a8a8b3;
	--ad-radius:     14px;
	--ad-transition: 0.2s cubic-bezier(0.4,0,0.2,1);
}
body, * { font-family: 'Cairo', sans-serif !important; }

/* Dashboard Header (page title) */
.hb-ad-pagetitle {
	display: flex;
	align-items: center;
	justify-content: space-between;
	flex-wrap: wrap;
	gap: 12px;
	margin-bottom: 10px;
}
.hb-ad-pagetitle h2 {
	font-size: 1.5rem;
	font-weight: 900;
	color: var(--ad-text);
	display: flex;
	align-items: center;
	gap: 12px;
}
.hb-ad-pagetitle h2 i {
	width: 44px; height: 44px;
	border-radius: 12px;
	background: linear-gradient(135deg, var(--ad-primary), #574fd6);
	display: flex; align-items: center; justify-content: center;
	font-size: 1.1rem;
}
.hb-ad-date {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	padding: 8px 16px;
	background: rgba(255,255,255,0.05);
	border: 1px solid var(--ad-border);
	border-radius: 30px;
	font-size: 0.82rem;
	color: var(--ad-muted);
}
.hb-ad-breadcrumb {
	display: flex;
	align-items: center;
	gap: 8px;
	font-size: 0.8rem;
	color: var(--ad-muted);
	margin-bottom: 28px;
}
.hb-ad-breadcrumb a { color: var(--ad-primary); }
.hb-ad-breadcrumb i { font-size: 0.65rem; }

/* ==============================
   STAT CARDS
============================== */
.hb-ad-stats {
	display: grid;
	grid-template-columns: repeat(4, 1fr);
	gap: 18px;
	margin-bottom: 36px;
}
.hb-ad-stat {
	background: var(--ad-card);
	border: 1px solid var(--ad-border);
	border-radius: var(--ad-radius);
	padding: 22px 22px 18px;
	position: relative;
	overflow: hidden;
	transition: transform var(--ad-transition), box-shadow var(--ad-transition);
	text-decoration: none;
	display: block;
}
.hb-ad-stat:hover {
	transform: translateY(-4px);
	box-shadow: 0 12px 28px rgba(0,0,0,0.3);
}
.hb-ad-stat-bg {
	position: absolute;
	top: -20px; left: -20px;
	width: 120px; height: 120px;
	border-radius: 50%;
	filter: blur(40px);
	opacity: 0.45;
}
.hb-stat-blue   .hb-ad-stat-bg { background: var(--ad-primary); }
.hb-stat-green  .hb-ad-stat-bg { background: var(--ad-success); }
.hb-stat-cyan   .hb-ad-stat-bg { background: var(--ad-info); }
.hb-stat-pink   .hb-ad-stat-bg { background: var(--ad-danger); }

.hb-ad-stat-icon {
	width: 44px; height: 44px;
	border-radius: 12px;
	display: flex; align-items: center; justify-content: center;
	font-size: 1.1rem;
	color: #fff;
	margin-bottom: 14px;
	position: relative;
}
.hb-stat-blue  .hb-ad-stat-icon { background: linear-gradient(135deg, var(--ad-primary), #574fd6); box-shadow: 0 4px 12px rgba(108,99,255,0.4); }
.hb-stat-green .hb-ad-stat-icon { background: linear-gradient(135deg, var(--ad-success), #059669); box-shadow: 0 4px 12px rgba(16,185,129,0.4); }
.hb-stat-cyan  .hb-ad-stat-icon { background: linear-gradient(135deg, var(--ad-info), #38bdf8); box-shadow: 0 4px 12px rgba(76,201,240,0.4); }
.hb-stat-pink  .hb-ad-stat-icon { background: linear-gradient(135deg, var(--ad-danger), #b5179e); box-shadow: 0 4px 12px rgba(247,37,133,0.4); }

.hb-ad-stat-value {
	font-size: 2rem;
	font-weight: 900;
	color: var(--ad-text);
	line-height: 1;
	margin-bottom: 4px;
	position: relative;
}
.hb-ad-stat-label {
	font-size: 0.8rem;
	color: var(--ad-muted);
	font-weight: 600;
	position: relative;
}

/* ==============================
   SECTION HEADERS
============================== */
.hb-ad-section-header {
	display: flex;
	align-items: center;
	justify-content: space-between;
	padding: 14px 20px;
	background: var(--ad-card);
	border: 1px solid var(--ad-border);
	border-radius: var(--ad-radius) var(--ad-radius) 0 0;
	border-bottom: 2px solid var(--ad-primary);
}
.hb-ad-section-header h3 {
	font-size: 0.95rem;
	font-weight: 800;
	color: var(--ad-text);
	display: flex;
	align-items: center;
	gap: 10px;
}
.hb-ad-section-header h3 i { color: var(--ad-primary); }
.hb-ad-section-header .hb-ad-view-all {
	font-size: 0.78rem;
	color: var(--ad-primary);
	font-weight: 700;
	padding: 5px 12px;
	border: 1px solid rgba(108,99,255,0.3);
	border-radius: 6px;
	transition: background var(--ad-transition);
}
.hb-ad-section-header .hb-ad-view-all:hover { background: rgba(108,99,255,0.1); }

/* ==============================
   TABLES
============================== */
.hb-ad-table-wrap {
	background: var(--ad-card);
	border: 1px solid var(--ad-border);
	border-top: none;
	border-radius: 0 0 var(--ad-radius) var(--ad-radius);
	overflow: hidden;
	margin-bottom: 28px;
}
.hb-ad-table {
	width: 100%;
	border-collapse: collapse;
	font-size: 0.85rem;
}
.hb-ad-table thead tr {
	background: rgba(255,255,255,0.03);
	border-bottom: 1px solid var(--ad-border);
}
.hb-ad-table thead th {
	padding: 12px 16px;
	text-align: right;
	font-weight: 700;
	color: var(--ad-muted);
	font-size: 0.78rem;
	text-transform: uppercase;
	letter-spacing: 0.5px;
}
.hb-ad-table tbody tr {
	border-bottom: 1px solid var(--ad-border);
	transition: background var(--ad-transition);
}
.hb-ad-table tbody tr:last-child { border-bottom: none; }
.hb-ad-table tbody tr:hover { background: rgba(255,255,255,0.03); }
.hb-ad-table td {
	padding: 13px 16px;
	color: var(--ad-text);
	vertical-align: middle;
}

/* Status badges */
.hb-ad-status {
	display: inline-flex;
	align-items: center;
	gap: 5px;
	padding: 4px 10px;
	border-radius: 6px;
	font-size: 0.72rem;
	font-weight: 700;
	white-space: nowrap;
}
.hb-st-pending  { background: rgba(245,158,11,0.12); color: var(--ad-warning); border: 1px solid rgba(245,158,11,0.3); }
.hb-st-shipping { background: rgba(76,201,240,0.12); color: var(--ad-info); border: 1px solid rgba(76,201,240,0.3); }
.hb-st-done     { background: rgba(16,185,129,0.12); color: var(--ad-success); border: 1px solid rgba(16,185,129,0.3); }
.hb-st-canceled { background: rgba(247,37,133,0.12); color: var(--ad-danger); border: 1px solid rgba(247,37,133,0.3); }

/* Action buttons */
.hb-ad-btn {
	display: inline-flex;
	align-items: center;
	gap: 5px;
	padding: 6px 12px;
	border-radius: 8px;
	font-size: 0.78rem;
	font-weight: 700;
	transition: filter var(--ad-transition);
	text-decoration: none;
}
.hb-ad-btn:hover { filter: brightness(1.15); }
.hb-ad-btn-default { background: rgba(255,255,255,0.07); color: var(--ad-text); border: 1px solid var(--ad-border); }
.hb-ad-btn-danger  { background: rgba(247,37,133,0.1); color: var(--ad-danger); border: 1px solid rgba(247,37,133,0.3); }

/* Bottom 2-col grid */
.hb-ad-bottom-grid {
	display: grid;
	grid-template-columns: 1fr 1fr;
	gap: 24px;
}

/* Badge (counter) */
.hb-ad-table .badge,
.hb-ad-id-badge {
	display: inline-flex;
	align-items: center;
	justify-content: center;
	min-width: 24px; height: 24px;
	padding: 0 7px;
	background: rgba(108,99,255,0.15);
	border: 1px solid rgba(108,99,255,0.3);
	color: #c0bcff;
	font-size: 0.72rem;
	font-weight: 700;
	border-radius: 6px;
}

@media (max-width: 1100px) {
	.hb-ad-stats { grid-template-columns: repeat(2, 1fr); }
}
@media (max-width: 768px) {
	.hb-ad-stats { grid-template-columns: 1fr 1fr; }
	.hb-ad-bottom-grid { grid-template-columns: 1fr; }
}
@media (max-width: 480px) {
	.hb-ad-stats { grid-template-columns: 1fr; }
}
</style>

<!-- Page Header -->
<div class="hb-ad-pagetitle">
	<h2>
		<i class="fas fa-tachometer-alt"></i>
		رئيسية التحكم
	</h2>
	<div class="hb-ad-date">
		<i class="fas fa-calendar-alt"></i>
		<?php echo date_arabic(time()); ?>
	</div>
</div>
<div class="hb-ad-breadcrumb">
	<a href="<?php echo base_url('admin'); ?>">الرئيسية</a>
	<i class="fas fa-chevron-left"></i>
	<span>الصفحة الرئيسية</span>
</div>

<!-- Stat Cards -->
<div class="hb-ad-stats">
	<a href="<?php echo base_url("admin/products"); ?>" class="hb-ad-stat hb-stat-blue">
		<div class="hb-ad-stat-bg"></div>
		<div class="hb-ad-stat-icon"><i class="fas fa-box-open"></i></div>
		<div class="hb-ad-stat-value"><?php echo $mo1; ?></div>
		<div class="hb-ad-stat-label">عدد المنتوجات</div>
	</a>
	<a href="<?php echo base_url("admin/requests"); ?>" class="hb-ad-stat hb-stat-green">
		<div class="hb-ad-stat-bg"></div>
		<div class="hb-ad-stat-icon"><i class="fas fa-clock"></i></div>
		<div class="hb-ad-stat-value"><?php echo $mo2; ?></div>
		<div class="hb-ad-stat-label">طلبات بإنتظار التأكيد</div>
	</a>
	<a href="<?php echo base_url("admin/requests"); ?>" class="hb-ad-stat hb-stat-cyan">
		<div class="hb-ad-stat-bg"></div>
		<div class="hb-ad-stat-icon"><i class="fas fa-shipping-fast"></i></div>
		<div class="hb-ad-stat-value"><?php echo $mo3; ?></div>
		<div class="hb-ad-stat-label">طلبات تم تسليمها</div>
	</a>
	<a href="<?php echo base_url("admin/products"); ?>" class="hb-ad-stat hb-stat-pink">
		<div class="hb-ad-stat-bg"></div>
		<div class="hb-ad-stat-icon"><i class="fas fa-star"></i></div>
		<div class="hb-ad-stat-value"><?php echo $mo4; ?></div>
		<div class="hb-ad-stat-label">عدد التقييمات</div>
	</a>
</div>

<!-- Recent Orders -->
<div class="hb-ad-section-header">
	<h3><i class="fas fa-shopping-bag"></i> آخر الطلبات</h3>
	<a href="<?php echo base_url("admin/requests"); ?>" class="hb-ad-view-all">عرض الكل</a>
</div>
<div class="hb-ad-table-wrap">
	<table class="hb-ad-table" id="no-more-tables" role="table">
		<thead>
			<tr>
				<th>#</th>
				<th>المنتوج</th>
				<th>المشتري</th>
				<th>الهاتف</th>
				<th>المدينة</th>
				<th>التاريخ</th>
				<th>السعر</th>
				<th>الحالة</th>
				<th>التحكم</th>
			</tr>
		</thead>
		<tbody>
		<?php foreach($cat as $key) { ?>
			<tr>
				<td><span class="badge"><?php echo $key->id; ?></span></td>
				<td><?php
					$pcs = json_decode($key->products, TRUE);
					foreach($pcs as $p => $q) {
						echo get_info("products", $p, "title")." / العدد <b>".$q."</b><br>";
					}
				?></td>
				<td><?php echo $key->name; ?></td>
				<td><a href="tel:<?php echo $key->tele; ?>" style="color:var(--ad-info);"><?php echo $key->tele; ?></a></td>
				<td><?php echo $key->city; ?></td>
				<td><?php echo date("d/m/Y H:i", $key->date); ?></td>
				<td style="font-weight:800;color:var(--ad-info);"><?php echo $key->totalPrice; ?> DH</td>
				<td>
					<?php switch($key->status) {
						case 1: echo '<span class="hb-ad-status hb-st-pending"><i class="fas fa-clock"></i> بإنتظار التأكيد</span>'; break;
						case 2: echo '<span class="hb-ad-status hb-st-shipping"><i class="fas fa-box"></i> بإنتظار الشحن</span>'; break;
						case 3: echo '<span class="hb-ad-status hb-st-done"><i class="fas fa-shipping-fast"></i> تم الإرسال</span>'; break;
						case 0: echo '<span class="hb-ad-status hb-st-canceled"><i class="fas fa-times"></i> تم الإلغاء</span>'; break;
						default: echo '<span class="hb-ad-status hb-st-done"><i class="fas fa-check"></i> تم الإستلام</span>'; break;
					} ?>
				</td>
				<td>
					<a href="<?php echo base_url("admin/detiales/$key->id"); ?>" class="hb-ad-btn hb-ad-btn-default"><i class="fas fa-eye"></i> التفاصيل</a>
					<a href="<?php echo base_url("admin/delt/orders/$key->id/requests"); ?>" class="hb-ad-btn hb-ad-btn-danger" style="margin-top:4px;"><i class="fas fa-trash"></i> حذف</a>
				</td>
			</tr>
		<?php } ?>
		</tbody>
	</table>
</div>

<!-- Bottom 2 cols -->
<div class="hb-ad-bottom-grid">

	<!-- Last Added Products -->
	<div>
		<div class="hb-ad-section-header">
			<h3><i class="fas fa-boxes"></i> آخر المنتوجات</h3>
			<a href="<?php echo base_url("admin/products"); ?>" class="hb-ad-view-all">عرض الكل</a>
		</div>
		<div class="hb-ad-table-wrap">
			<table class="hb-ad-table">
				<thead>
					<tr>
						<th>#</th>
						<th>المنتوج</th>
						<th>السعر</th>
						<th>بعد الخصم</th>
						<th>التحكم</th>
					</tr>
				</thead>
				<tbody>
				<?php foreach($lastadd as $key) { ?>
					<tr>
						<td><span class="badge"><?php echo $key->id; ?></span></td>
						<td><?php echo $key->title; ?></td>
						<td><?php echo $key->price; ?> DH</td>
						<td style="color:var(--ad-success);font-weight:700;"><?php echo floor($key->price - ($key->price * $key->discount / 100)); ?> DH</td>
						<td>
							<a href="<?php echo base_url("admin/edit_product/$key->id"); ?>" class="hb-ad-btn hb-ad-btn-default"><i class="fas fa-edit"></i> تعديل</a>
							<a href="<?php echo base_url("admin/delt/products/$key->id/products"); ?>" class="hb-ad-btn hb-ad-btn-danger" style="margin-top:4px;"><i class="fas fa-trash"></i></a>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<!-- Active Coupons -->
	<div>
		<div class="hb-ad-section-header">
			<h3><i class="fas fa-tag"></i> الكوبونات المفعلة</h3>
			<a href="<?php echo base_url("admin/discounts"); ?>" class="hb-ad-view-all">عرض الكل</a>
		</div>
		<div class="hb-ad-table-wrap">
			<table class="hb-ad-table">
				<thead>
					<tr>
						<th>#</th>
						<th>كود التخفيض</th>
						<th>تاريخ الإنتهاء</th>
						<th>التحكم</th>
					</tr>
				</thead>
				<tbody>
				<?php foreach($endsoon as $key) { ?>
					<tr>
						<td><span class="badge"><?php echo $key->id; ?></span></td>
						<td><span style="font-weight:800;color:var(--ad-warning);letter-spacing:1px;"><?php echo $key->coupon; ?></span></td>
						<td><?php echo $key->date; ?></td>
						<td>
							<a href="<?php echo base_url("admin/edit_discount/$key->id"); ?>" class="hb-ad-btn hb-ad-btn-default"><i class="fas fa-edit"></i></a>
							<a href="<?php echo base_url("admin/delt/discounts/$key->id/discounts"); ?>" class="hb-ad-btn hb-ad-btn-danger" style="margin-top:4px;"><i class="fas fa-trash"></i></a>
						</td>
					</tr>
				<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

</div>

<?php require_once 'views/sidebar.php'; require_once 'views/foot.php'; ?>