<?php include_once 'header.php'; ?>

<style>
/* ==============================
   CART PAGE
============================== */
.hb-cart-section {
	max-width: 1280px;
	margin: 0 auto;
	padding: 50px 24px 80px;
}
.hb-cart-title {
	font-size: clamp(1.5rem, 3vw, 2rem);
	font-weight: 900;
	margin-bottom: 36px;
	display: flex;
	align-items: center;
	gap: 14px;
}
.hb-cart-title i {
	width: 50px; height: 50px;
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	border-radius: 14px;
	display: flex; align-items: center; justify-content: center;
	font-size: 1.2rem;
	flex-shrink: 0;
	box-shadow: 0 4px 16px rgba(108,99,255,0.35);
}

.hb-cart-layout {
	display: grid;
	grid-template-columns: 1fr 420px;
	gap: 30px;
	align-items: start;
}

/* ==============================
   CART ITEMS TABLE
============================== */
.hb-cart-items {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: 20px;
	overflow: hidden;
}
.hb-cart-items-header {
	padding: 18px 24px;
	border-bottom: 1px solid var(--border);
	font-size: 0.85rem;
	font-weight: 700;
	color: var(--text-muted);
	display: flex;
	justify-content: space-between;
}

.hb-cart-item {
	display: flex;
	align-items: center;
	gap: 18px;
	padding: 20px 24px;
	border-bottom: 1px solid var(--border);
	transition: background var(--transition);
}
.hb-cart-item:last-child { border-bottom: none; }
.hb-cart-item:hover { background: var(--surface); }

.hb-cart-item-img {
	width: 80px; height: 80px;
	border-radius: 12px;
	overflow: hidden;
	flex-shrink: 0;
	border: 1px solid var(--border);
	background: var(--dark-3);
}
.hb-cart-item-img img { width: 100%; height: 100%; object-fit: cover; }

.hb-cart-item-details { flex: 1; }
.hb-cart-item-details h3 {
	font-size: 0.95rem;
	font-weight: 700;
	margin-bottom: 6px;
	line-height: 1.4;
}
.hb-cart-item-details h3 a { color: var(--text); }
.hb-cart-item-details h3 a:hover { color: var(--primary); }

.lx-delete-cookie {
	display: inline-flex;
	align-items: center;
	gap: 5px;
	font-size: 0.78rem;
	color: var(--secondary);
	cursor: pointer;
	padding: 4px 10px;
	border-radius: 6px;
	border: 1px solid rgba(247,37,133,0.3);
	background: rgba(247,37,133,0.07);
	transition: background var(--transition);
}
.lx-delete-cookie:hover { background: rgba(247,37,133,0.15); }
.lx-delete-cookie::before { content: '✕ '; }

.hb-cart-item-price {
	font-size: 1.1rem;
	font-weight: 900;
	color: var(--accent);
	white-space: nowrap;
}

/* Empty Cart */
.hb-cart-empty {
	text-align: center;
	padding: 60px 24px;
}
.hb-cart-empty i { font-size: 3.5rem; color: var(--text-muted); margin-bottom: 16px; display: block; }
.hb-cart-empty p { color: var(--text-muted); font-size: 1rem; margin-bottom: 20px; }
.hb-cart-empty a {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	padding: 12px 24px;
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	border-radius: var(--radius-sm);
	font-weight: 700;
	font-size: 0.9rem;
}

/* Summary bar */
.hb-cart-summary-bar {
	padding: 16px 24px;
	border-top: 1px solid var(--border);
	background: var(--dark-3);
}
.hb-cart-summary-row {
	display: flex;
	justify-content: space-between;
	align-items: center;
	font-size: 0.9rem;
	padding: 4px 0;
	color: var(--text-muted);
}
.hb-cart-summary-row .ship,
.lx-shipping-costs .ship {
	font-weight: 700;
	color: var(--text);
}
.hb-cart-summary-row.total {
	font-size: 1.05rem;
	font-weight: 900;
	color: var(--text);
	margin-top: 8px;
	padding-top: 12px;
	border-top: 1px solid var(--border);
}
.totalprice, .hb-cart-summary-row.total .totalprice {
	font-size: 1.3rem;
	color: var(--accent);
}
.couponUse {
	font-size: 0.82rem;
	color: #4ade80;
	min-height: 0;
	margin: 0;
}

/* ==============================
   ORDER FORM (sidebar)
============================== */
.hb-order-form {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: 20px;
	overflow: hidden;
	position: sticky;
	top: 90px;
}
.hb-order-form-header {
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	padding: 20px 24px;
}
.hb-order-form-header h3 {
	font-size: 1.05rem;
	font-weight: 800;
	color: #fff;
	display: flex;
	align-items: center;
	gap: 10px;
}
.hb-order-form-body {
	padding: 24px;
}
.hb-form-group {
	margin-bottom: 16px;
}
.hb-form-group label {
	display: flex;
	align-items: center;
	gap: 8px;
	font-size: 0.82rem;
	font-weight: 700;
	color: var(--text-muted);
	margin-bottom: 6px;
}
.hb-form-group label i { color: var(--primary); }
.hb-form-group input[type="text"],
.hb-form-group input[type="tel"] {
	width: 100%;
	background: var(--dark-3);
	border: 1px solid var(--border);
	border-radius: var(--radius-sm);
	padding: 12px 14px;
	color: var(--text);
	font-size: 0.95rem;
	outline: none;
	transition: border-color var(--transition);
}
.hb-form-group input:focus { border-color: var(--primary); }

/* Coupon row */
.hb-coupon-row {
	display: flex;
	gap: 8px;
	margin-bottom: 0;
}
.hb-coupon-row input {
	flex: 1;
	background: var(--dark-3);
	border: 1px solid var(--border);
	border-radius: var(--radius-sm);
	padding: 11px 14px;
	color: var(--text);
	font-size: 0.9rem;
	outline: none;
	transition: border-color var(--transition);
}
.hb-coupon-row input:focus { border-color: var(--primary); }
.lx-applycoupon {
	padding: 11px 16px;
	border-radius: var(--radius-sm);
	background: var(--surface);
	border: 1px solid var(--border);
	color: var(--text);
	font-size: 0.85rem;
	font-weight: 700;
	cursor: pointer;
	white-space: nowrap;
	transition: background var(--transition), color var(--transition);
}
.lx-applycoupon:hover { background: var(--primary); color: #fff; border-color: var(--primary); }
.lx-coupon-warning {
	font-size: 0.8rem;
	color: var(--secondary);
	margin-top: 6px;
	min-height: 0;
}

/* Submit button */
.lx-cart-next-step {
	margin-top: 20px;
}
.lx-cart-next-step a {
	display: flex;
	align-items: center;
	justify-content: center;
	gap: 12px;
	width: 100%;
	padding: 16px;
	background: linear-gradient(135deg, var(--primary), var(--secondary));
	color: #fff;
	border-radius: var(--radius-sm);
	font-weight: 800;
	font-size: 1rem;
	box-shadow: 0 4px 20px rgba(108,99,255,0.35);
	transition: filter var(--transition), transform var(--transition);
}
.lx-cart-next-step a:hover { filter: brightness(1.12); transform: translateY(-2px); }

/* Trust badges */
.hb-trust-badges {
	display: flex;
	justify-content: center;
	gap: 16px;
	padding: 16px 24px;
	border-top: 1px solid var(--border);
}
.hb-trust-badge {
	display: flex;
	flex-direction: column;
	align-items: center;
	gap: 4px;
	font-size: 0.7rem;
	color: var(--text-muted);
	font-weight: 600;
}
.hb-trust-badge i { font-size: 1.2rem; color: var(--primary); }

@media (max-width: 960px) {
	.hb-cart-layout { grid-template-columns: 1fr; }
	.hb-order-form { position: static; }
}
@media (max-width: 480px) {
	.hb-cart-item { flex-direction: column; align-items: flex-start; }
	.hb-cart-item-img { width: 100%; height: 160px; border-radius: var(--radius); }
}
</style>

<div class="hb-cart-section">
	<h1 class="hb-cart-title">
		<i class="fas fa-shopping-bag"></i>
		سلة المشتريات
	</h1>

	<form action="" method="post" id="sendcart">

		<div class="hb-cart-layout">

			<!-- LEFT: Items -->
			<div>
				<div class="hb-cart-items">
					<?php if(count($info) > 0): ?>
					<div class="hb-cart-items-header">
						<span>المنتوج</span>
						<span>السعر</span>
					</div>

					<?php $tprice = 0; $ship = 0; foreach($info as $cart):
						$pr  = floor($cart->price - ($cart->price * $cart->discount / 100));
						$tpr = isset($arr[$cart->id]['q']) ? $pr * $arr[$cart->id]['q'] : $pr;
					?>
					<div class="hb-cart-item items">
						<div class="hb-cart-item-img lx-cart-products-list-img" data-id="<?php echo $cart->id; ?>">
							<a href="<?php echo base_url("home/show/$cart->id"); ?>">
								<img src="<?php echo base_url("uploads")."/" . add_thumb($cart->images, "_m"); ?>" />
							</a>
						</div>
						<div class="hb-cart-item-details">
							<h3><a href="<?php echo base_url("home/show/$cart->id"); ?>"><?php echo $cart->title; ?></a></h3>
							<a href="javascript:;" data-id="<?php echo $cart->id; ?>" class="lx-delete-cookie">إزالة</a>
						</div>
						<div class="hb-cart-item-price lx-price-total"><?php echo $tpr; ?> DH</div>
					</div>
					<?php $tprice = $tprice + $tpr; $ship = $ship + $cart->shipping; endforeach; ?>

					<!-- Summary -->
					<div class="hb-cart-summary-bar">
						<p class="couponUse"></p>
						<div class="hb-cart-summary-row lx-shipping-costs">
							<span>مصاريف الشحن</span>
							<span><b class="ship"><?php echo $ship; ?> DH</b></span>
						</div>
						<div class="hb-cart-summary-row total lx-total-costs">
							<span>المجموع</span>
							<strong class="totalprice"><?php echo $tprice; ?> DH</strong>
						</div>
					</div>
					<input type="hidden" name="totalprice" id="value" value="<?php echo $tprice; ?>" />

					<?php else: ?>
					<div class="hb-cart-empty">
						<i class="fas fa-shopping-bag"></i>
						<p>لا توجد منتوجات في سلتك حاليا</p>
						<a href="<?php echo base_url(); ?>"><i class="fas fa-arrow-right"></i> تسوق الآن</a>
					</div>
					<?php endif; ?>
				</div>
			</div>

			<!-- RIGHT: Order Form -->
			<div class="hb-order-form">
				<div class="hb-order-form-header">
					<h3><i class="fas fa-clipboard-list"></i> تفاصيل الطلب</h3>
				</div>
				<div class="hb-order-form-body lx-cart-info-address">
					<div class="hb-form-group">
						<label><i class="fas fa-user"></i> الإسم الكامل</label>
						<input type="text" name="fullname" placeholder="أدخل إسمك الكامل" />
					</div>
					<div class="hb-form-group">
						<label><i class="fas fa-phone"></i> رقم الهاتف</label>
						<input type="tel" name="phone" placeholder="0600000000" />
					</div>
					<div class="hb-form-group">
						<label><i class="fas fa-map-marker-alt"></i> العنوان</label>
						<input type="text" name="address" placeholder="الحي، الزنقة..." />
					</div>
					<div class="hb-form-group">
						<label><i class="fas fa-city"></i> المدينة</label>
						<input type="text" name="city" placeholder="الدار البيضاء...">
					</div>
					<div class="hb-form-group">
						<label><i class="fas fa-tag"></i> كود التخفيض (اختياري)</label>
						<div class="hb-coupon-row">
							<input type="text" name="coupon" id="coupon" placeholder="PROMO2024" />
							<a href="javascript:;" class="lx-applycoupon" data-activated="no">تفعيل</a>
						</div>
						<p dir="rtl" class="lx-coupon-warning"></p>
					</div>

					<div class="lx-cart-next-step">
						<a href="javascript:;">
							<i class="fas fa-check-circle"></i>
							تأكيد الطلب
						</a>
					</div>
				</div>

				<div class="hb-trust-badges">
					<div class="hb-trust-badge"><i class="fas fa-lock"></i><span>آمن 100%</span></div>
					<div class="hb-trust-badge"><i class="fas fa-shipping-fast"></i><span>توصيل سريع</span></div>
					<div class="hb-trust-badge"><i class="fas fa-undo"></i><span>ضمان الإسترجاع</span></div>
				</div>
			</div>

		</div>

	</form>
</div>

<?php include_once 'footer.php'; ?>