<?php include_once 'header.php'; ?>

<style>
/* Category Page */
.hb-cat-hero {
	background: linear-gradient(135deg, var(--dark-2), var(--dark-3));
	border-bottom: 1px solid var(--border);
	padding: 50px 0 40px;
	margin-bottom: 50px;
	position: relative;
	overflow: hidden;
}
.hb-cat-hero::before {
	content: '';
	position: absolute;
	inset: 0;
	background: radial-gradient(circle at 70% 50%, rgba(108,99,255,0.12) 0%, transparent 60%);
}
.hb-cat-hero-inner {
	max-width: 1280px;
	margin: 0 auto;
	padding: 0 24px;
	position: relative;
	z-index: 1;
}
.hb-cat-hero h2 {
	font-size: clamp(1.6rem, 3vw, 2.4rem);
	font-weight: 900;
	display: flex;
	align-items: center;
	gap: 14px;
}
.hb-cat-hero h2 .hb-cat-icon {
	width: 52px; height: 52px;
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	border-radius: 16px;
	display: flex; align-items: center; justify-content: center;
	font-size: 1.3rem;
	flex-shrink: 0;
	box-shadow: 0 4px 20px rgba(108,99,255,0.4);
}
.hb-cat-breadcrumb {
	display: flex;
	align-items: center;
	gap: 8px;
	margin-top: 10px;
	font-size: 0.82rem;
	color: var(--text-muted);
}
.hb-cat-breadcrumb a { color: var(--primary); }
.hb-cat-breadcrumb i { font-size: 0.65rem; }

/* Product count badge */
.hb-cat-count {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	padding: 6px 14px;
	background: var(--surface);
	border: 1px solid var(--border);
	border-radius: 30px;
	font-size: 0.82rem;
	color: var(--text-muted);
	margin-top: 14px;
}

/* Products grid (shared styles from index) */
.hb-products-grid {
	display: grid;
	grid-template-columns: repeat(4, 1fr);
	gap: 20px;
}
.hb-product-card {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: var(--radius);
	overflow: hidden;
	transition: transform var(--transition), box-shadow var(--transition), border-color var(--transition);
}
.hb-product-card:hover {
	transform: translateY(-6px);
	box-shadow: var(--shadow);
	border-color: rgba(108,99,255,0.35);
}
.hb-product-card a { display: block; color: inherit; }
.hb-product-img-wrap {
	position: relative;
	aspect-ratio: 1;
	overflow: hidden;
	background: var(--dark-3);
}
.hb-product-img-wrap img { width: 100%; height: 100%; object-fit: cover; transition: transform 0.4s ease; }
.hb-product-card:hover .hb-product-img-wrap img { transform: scale(1.08); }
.hb-discount-badge {
	position: absolute;
	top: 12px; right: 12px;
	background: linear-gradient(135deg, var(--secondary), #b5179e);
	color: #fff;
	font-size: 0.72rem;
	font-weight: 800;
	padding: 5px 10px;
	border-radius: 8px;
	letter-spacing: 0.3px;
	box-shadow: 0 2px 10px rgba(247,37,133,0.5);
	text-align: center;
	line-height: 1.3;
	z-index: 1;
}
.hb-product-overlay {
	position: absolute; inset: 0;
	background: linear-gradient(to top, rgba(108,99,255,0.85) 0%, transparent 60%);
	display: flex; align-items: flex-end; justify-content: center;
	padding-bottom: 16px;
	opacity: 0;
	transition: opacity var(--transition);
}
.hb-product-card:hover .hb-product-overlay { opacity: 1; }
.hb-product-overlay span {
	background: #fff;
	color: var(--primary-dark);
	padding: 8px 22px;
	border-radius: 30px;
	font-weight: 700;
	font-size: 0.82rem;
}
.hb-product-info { padding: 14px 16px 18px; }
.hb-product-title {
	font-size: 0.92rem;
	font-weight: 700;
	margin-bottom: 8px;
	display: -webkit-box;
	-webkit-line-clamp: 2;
	-webkit-box-orient: vertical;
	overflow: hidden;
	line-height: 1.45;
}
.hb-product-price { display: flex; align-items: center; gap: 10px; flex-wrap: wrap; }
.hb-price-old { font-size: 0.82rem; color: var(--text-muted); text-decoration: line-through; }
.hb-price-new { font-size: 1.05rem; font-weight: 900; color: var(--accent); }
.hb-price-only { font-size: 1.05rem; font-weight: 900; color: var(--text); }

/* Empty State */
.hb-empty {
	text-align: center;
	padding: 80px 24px;
}
.hb-empty i { font-size: 3.5rem; color: var(--text-muted); margin-bottom: 20px; display: block; }
.hb-empty h3 { font-size: 1.3rem; color: var(--text-muted); }

@media (max-width: 1100px) { .hb-products-grid { grid-template-columns: repeat(3, 1fr); } }
@media (max-width: 768px)  { .hb-products-grid { grid-template-columns: repeat(2, 1fr); gap: 14px; } }
@media (max-width: 480px)  { .hb-products-grid { grid-template-columns: repeat(2, 1fr); gap: 10px; } }
</style>

<!-- Category Hero -->
<div class="hb-cat-hero">
	<div class="hb-cat-hero-inner">
		<h2>
			<span class="hb-cat-icon"><i class="fas fa-layer-group"></i></span>
			<?php echo $title; ?>
		</h2>
		<div class="hb-cat-breadcrumb">
			<a href="<?php echo base_url(); ?>">الرئيسية</a>
			<i class="fas fa-chevron-left"></i>
			<span><?php echo $title; ?></span>
		</div>
		<div class="hb-cat-count">
			<i class="fas fa-box-open"></i>
			<?php echo count($products); ?> منتوج
		</div>
	</div>
</div>

<!-- Products Section -->
<div class="hb-section">
	<?php if(count($products) > 0): ?>
	<div class="hb-products-grid">
		<?php $i = 0; foreach($products as $p) : $i++; ?>
		<div class="hb-product-card">
			<a href="<?php echo base_url("home/show/$p->id"); ?>">
				<div class="hb-product-img-wrap">
					<?php if($p->discount != 0): ?>
					<span class="hb-discount-badge"><?php echo $p->discount; ?>%<br>OFF</span>
					<?php endif; ?>
					<img src="uploads/<?php echo add_thumb($p->images, "_m") ?>" alt="<?php echo $p->title; ?>" loading="lazy"/>
					<div class="hb-product-overlay">
						<span><i class="fas fa-shopping-bag"></i> عرض المنتوج</span>
					</div>
				</div>
				<div class="hb-product-info">
					<div class="hb-product-title"><?php echo $p->title; ?></div>
					<div class="hb-product-price">
						<?php if($p->discount != 0): ?>
						<span class="hb-price-old"><?php echo $p->price; ?>DH</span>
						<span class="hb-price-new"><?php echo floor($p->price - ($p->price * $p->discount / 100)); ?>DH</span>
						<?php else: ?>
						<span class="hb-price-only"><?php echo $p->price; ?>DH</span>
						<?php endif; ?>
					</div>
				</div>
			</a>
		</div>
		<?php endforeach; ?>
	</div>
	<?php else: ?>
	<div class="hb-empty">
		<i class="fas fa-box-open"></i>
		<h3>لا توجد منتوجات في هذا القسم حاليا</h3>
	</div>
	<?php endif; ?>
</div>

<?php include_once 'footer.php'; ?>

<script type="text/javascript">
	// Category infinite scroll placeholder (preserved from original)
</script>