<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
	<meta charset="utf-8">
	<title><?php echo setting("title"); ?> - <?php echo isset($title) ? $title : "بيع جميع أنواع السلع"; ?></title>

	<base href="<?php echo base_url(); ?>">

	<script type="text/javascript">
		var base_url = "<?php echo base_url(); ?>";
	</script>

	<meta name="description" content="<?php echo setting("descr"); ?>">
	<meta name="keywords" content="xmall,hmizat,avito,jumia,online shopping,">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="subject" content="e-commerce">
	<meta name="language" content="AR">
	<meta name="robots" content="index,follow" />
	<meta name="Classification" content="Business">
	<meta name="author" content="hobrt, hobrt.me">
	<meta name="og:title" content="<?php echo setting("title"); ?> - <?php echo isset($title) ? $title : "بيع جميع أنواع السلع"; ?>"/>
	<meta name="og:type" content="e-commerce"/>
	<meta name="og:url" content="<?php echo base_url() ?>"/>
	<meta name="og:site_name" content="<?php echo setting("title"); ?>"/>
	<meta name="og:description" content="<?php echo setting("descr"); ?>"/>

	<!-- Google Fonts -->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;600;700;900&display=swap" rel="stylesheet">

	<!-- Font Awesome -->
	<link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.6.1/css/all.css" integrity="sha384-gfdkjb5BdAXd+lj+gudLWI+BXq4IuLW5IT+brZEZsLFm++aCMlF1V92rMkPaX4PP" crossorigin="anonymous">

	<!-- Fav Icon -->
	<link rel="shortcut icon" href="favicon.ico">

	<?php echo setting("googlea"); ?>
	<?php echo setting("fbpixel"); ?>

	<style>
	/* ==============================
	   DESIGN SYSTEM / VARIABLES
	============================== */
	:root {
		--primary: #6c63ff;
		--primary-dark: #574fd6;
		--secondary: #f72585;
		--accent: #4cc9f0;
		--dark: #0f0e17;
		--dark-2: #1a1927;
		--dark-3: #252436;
		--text: #fffffe;
		--text-muted: #a8a8b3;
		--surface: rgba(255,255,255,0.07);
		--surface-hover: rgba(255,255,255,0.12);
		--border: rgba(255,255,255,0.1);
		--radius: 14px;
		--radius-sm: 8px;
		--shadow: 0 8px 32px rgba(0,0,0,0.35);
		--shadow-sm: 0 2px 12px rgba(0,0,0,0.2);
		--transition: 0.25s cubic-bezier(0.4,0,0.2,1);
		--font: 'Cairo', sans-serif;
	}

	/* ==============================
	   RESET & BASE
	============================== */
	*, *::before, *::after { box-sizing: border-box; margin: 0; padding: 0; }

	html { scroll-behavior: smooth; }

	body {
		font-family: var(--font);
		background: var(--dark);
		color: var(--text);
		direction: rtl;
		overflow-x: hidden;
		line-height: 1.7;
	}

	a { color: inherit; text-decoration: none; }
	img { max-width: 100%; display: block; }
	ul { list-style: none; }
	input, textarea, select, button { font-family: var(--font); }

	/* ==============================
	   NAV BAR
	============================== */
	.hb-nav {
		position: fixed;
		top: 0; right: 0; left: 0;
		z-index: 1000;
		background: rgba(15, 14, 23, 0.75);
		backdrop-filter: blur(18px);
		-webkit-backdrop-filter: blur(18px);
		border-bottom: 1px solid var(--border);
		box-shadow: var(--shadow-sm);
		transition: background var(--transition), box-shadow var(--transition);
	}
	.hb-nav.scrolled {
		background: rgba(15, 14, 23, 0.97);
		box-shadow: var(--shadow);
	}

	.hb-nav-inner {
		max-width: 1280px;
		margin: 0 auto;
		padding: 0 24px;
		height: 70px;
		display: flex;
		align-items: center;
		justify-content: space-between;
		gap: 20px;
	}

	/* Logo */
	.hb-logo {
		flex-shrink: 0;
	}
	.hb-logo img {
		height: 48px;
		width: auto;
		object-fit: contain;
		filter: brightness(1.1);
		transition: transform var(--transition);
	}
	.hb-logo:hover img { transform: scale(1.05); }

	/* Desktop Menu */
	.hb-menu {
		display: flex;
		align-items: center;
		gap: 4px;
		flex: 1;
		justify-content: center;
	}
	.hb-menu a {
		padding: 8px 16px;
		border-radius: 10px;
		font-size: 0.95rem;
		font-weight: 600;
		color: var(--text-muted);
		transition: color var(--transition), background var(--transition);
		white-space: nowrap;
	}
	.hb-menu a:hover {
		color: var(--text);
		background: var(--surface-hover);
	}
	.hb-menu .hb-sale {
		color: var(--secondary);
		position: relative;
	}
	.hb-menu .hb-sale::after {
		content: '';
		position: absolute;
		bottom: 4px; right: 16px; left: 16px;
		height: 2px;
		background: var(--secondary);
		border-radius: 2px;
		transform: scaleX(0);
		transition: transform var(--transition);
	}
	.hb-menu .hb-sale:hover::after { transform: scaleX(1); }

	/* Actions (cart + contact + mobile toggle) */
	.hb-actions {
		display: flex;
		align-items: center;
		gap: 10px;
		flex-shrink: 0;
	}

	/* Cart Button */
	.hb-cart-btn {
		position: relative;
		display: flex;
		align-items: center;
		justify-content: center;
		width: 44px; height: 44px;
		border-radius: 12px;
		background: var(--surface);
		border: 1px solid var(--border);
		color: var(--text);
		font-size: 1.1rem;
		transition: background var(--transition), transform var(--transition);
	}
	.hb-cart-btn:hover { background: var(--surface-hover); transform: translateY(-2px); }
	.hb-cart-btn .hb-badge {
		position: absolute;
		top: -6px; left: -6px;
		width: 20px; height: 20px;
		border-radius: 50%;
		background: var(--secondary);
		color: #fff;
		font-size: 0.7rem;
		font-weight: 700;
		display: flex; align-items: center; justify-content: center;
		box-shadow: 0 2px 8px rgba(247,37,133,0.5);
		animation: pulse-badge 2s infinite;
	}
	@keyframes pulse-badge {
		0%, 100% { box-shadow: 0 2px 8px rgba(247,37,133,0.5); }
		50% { box-shadow: 0 2px 16px rgba(247,37,133,0.9); }
	}

	/* Contact Dropdown */
	.hb-contact-wrap {
		position: relative;
	}
	.hb-contact-toggle {
		display: flex;
		align-items: center;
		gap: 8px;
		padding: 8px 16px;
		border-radius: 12px;
		background: linear-gradient(135deg, var(--primary), var(--primary-dark));
		font-size: 0.9rem;
		font-weight: 700;
		color: #fff;
		cursor: pointer;
		border: none;
		outline: none;
		transition: filter var(--transition), transform var(--transition);
	}
	.hb-contact-toggle:hover { filter: brightness(1.15); transform: translateY(-2px); }

	.hb-contact-dropdown {
		position: absolute;
		top: calc(100% + 12px);
		left: 0;
		min-width: 220px;
		background: var(--dark-2);
		border: 1px solid var(--border);
		border-radius: var(--radius);
		box-shadow: var(--shadow);
		padding: 10px;
		display: none;
		flex-direction: column;
		gap: 6px;
		z-index: 100;
		animation: fadeSlideDown 0.2s ease forwards;
	}
	.hb-contact-wrap:hover .hb-contact-dropdown,
	.hb-contact-wrap.open .hb-contact-dropdown {
		display: flex;
	}
	@keyframes fadeSlideDown {
		from { opacity: 0; transform: translateY(-8px); }
		to   { opacity: 1; transform: translateY(0); }
	}
	.hb-contact-dropdown a {
		display: flex;
		align-items: center;
		gap: 10px;
		padding: 10px 14px;
		border-radius: var(--radius-sm);
		font-size: 0.9rem;
		font-weight: 600;
		transition: background var(--transition);
	}
	.hb-contact-dropdown a:hover { background: var(--surface-hover); }
	.hb-contact-dropdown a i { font-size: 1.1rem; width: 20px; text-align: center; }
	.hb-contact-dropdown .lx-color1 i { color: var(--accent); }
	.hb-contact-dropdown .lx-color3 i { color: #25d366; }
	.hb-contact-dropdown .lx-color4 i { color: #0084ff; }

	/* Mobile Toggle */
	.hb-mobile-toggle {
		display: none;
		width: 44px; height: 44px;
		align-items: center; justify-content: center;
		border-radius: 12px;
		background: var(--surface);
		border: 1px solid var(--border);
		color: var(--text);
		font-size: 1.15rem;
		cursor: pointer;
		transition: background var(--transition);
	}
	.hb-mobile-toggle:hover { background: var(--surface-hover); }

	/* Mobile Drawer */
	.hb-drawer {
		display: none;
		position: fixed;
		top: 70px; right: 0; left: 0; bottom: 0;
		background: rgba(15, 14, 23, 0.97);
		backdrop-filter: blur(18px);
		z-index: 999;
		padding: 24px;
		flex-direction: column;
		gap: 8px;
		overflow-y: auto;
		transform: translateX(-100%);
		transition: transform 0.3s cubic-bezier(0.4,0,0.2,1);
	}
	.hb-drawer.active {
		display: flex;
		transform: translateX(0);
	}
	.hb-drawer a {
		padding: 14px 20px;
		border-radius: var(--radius);
		font-size: 1rem;
		font-weight: 600;
		color: var(--text-muted);
		border: 1px solid var(--border);
		background: var(--surface);
		transition: all var(--transition);
		text-align: center;
	}
	.hb-drawer a:hover { color: var(--text); background: var(--surface-hover); border-color: var(--primary); }
	.hb-drawer .hb-sale { color: var(--secondary); }

	/* Announcement Bar */
	.hb-announce {
		background: linear-gradient(90deg, var(--primary), var(--secondary));
		color: #fff;
		text-align: center;
		padding: 8px 16px;
		font-size: 0.82rem;
		font-weight: 700;
		letter-spacing: 0.3px;
	}

	/* Page wrapper push for fixed nav */
	.hb-page-wrap {
		padding-top: 70px;
	}

	/* ==============================
	   UTILITIES
	============================== */
	.hb-container {
		max-width: 1280px;
		margin: 0 auto;
		padding: 0 24px;
	}

	/* ==============================
	   RESPONSIVE
	============================== */
	@media (max-width: 900px) {
		.hb-menu { display: none; }
		.hb-contact-wrap { display: none; }
		.hb-mobile-toggle { display: flex; }
	}
	</style>
</head>
<body>

<?php echo setting("header"); ?>

<nav class="hb-nav" id="hb-nav">
	<div class="hb-nav-inner">

		<!-- Logo -->
		<a href="<?php echo base_url(); ?>" class="hb-logo">
			<img src="logo/<?php echo setting('logo'); ?>" alt="<?php echo setting('title'); ?>">
		</a>

		<!-- Desktop Menu -->
		<div class="hb-menu">
			<?php foreach($cats as $cat) : ?>
				<a href="category/<?php echo $cat->id; ?>"><?php echo $cat->title; ?></a>
			<?php endforeach; ?>
			<a href="special/تخفيضات" class="hb-sale"><i class="fas fa-tag" style="margin-left:4px;"></i>تخفيضات</a>
		</div>

		<!-- Actions -->
		<div class="hb-actions">
			<!-- Cart -->
			<a href="<?php echo base_url("home/cart"); ?>" class="hb-cart-btn">
				<i class="fas fa-shopping-bag"></i>
				<?php $cart = is_null(get_cookie("cart")) ? array() : json_decode(get_cookie("cart"), TRUE);
				if(count($cart) > 0): ?>
					<span class="hb-badge"><?php echo count($cart); ?></span>
				<?php endif; ?>
			</a>

			<!-- Contact Dropdown -->
			<div class="hb-contact-wrap">
				<button class="hb-contact-toggle" id="hb-contact-btn">
					<i class="fas fa-headset"></i>
					تواصل معنا
				</button>
				<div class="hb-contact-dropdown">
					<?php $teles = explode(";", setting("teles")); foreach($teles as $t) : ?>
						<a href="tel:<?php echo $t; ?>" class="lx-color1"><i class="fas fa-phone"></i> <?php echo $t; ?></a>
					<?php endforeach; ?>
					<?php $teles = explode(";", setting("whs")); foreach($teles as $t) : ?>
						<a href="https://wa.me/212<?php echo $t; ?>" class="lx-color3"><i class="fab fa-whatsapp"></i> <?php echo $t; ?></a>
					<?php endforeach; ?>
					<?php $teles = explode(";", setting("messangers")); foreach($teles as $t) : ?>
						<a href="https://www.messenger.com/t/<?php echo $t; ?>" target="_blank" class="lx-color4"><i class="fab fa-facebook-messenger"></i> Messenger</a>
					<?php endforeach; ?>
				</div>
			</div>

			<!-- Mobile Toggle -->
			<button class="hb-mobile-toggle" id="hb-mobile-toggle" aria-label="القائمة">
				<i class="fas fa-bars" id="hb-toggle-icon"></i>
			</button>
		</div>
	</div>
</nav>

<!-- Mobile Drawer -->
<div class="hb-drawer" id="hb-drawer">
	<?php foreach($cats as $cat) : ?>
		<a href="category/<?php echo $cat->id; ?>"><?php echo $cat->title; ?></a>
	<?php endforeach; ?>
	<a href="special/تخفيضات" class="hb-sale"><i class="fas fa-tag" style="margin-left:6px;"></i>تخفيضات</a>
	<?php $teles = explode(";", setting("teles")); foreach($teles as $t) : ?>
		<a href="tel:<?php echo $t; ?>" style="color:var(--accent);"><i class="fas fa-phone" style="margin-left:6px;"></i> <?php echo $t; ?></a>
	<?php endforeach; ?>
	<?php $teles = explode(";", setting("whs")); foreach($teles as $t) : ?>
		<a href="https://wa.me/212<?php echo $t; ?>" style="color:#25d366;"><i class="fab fa-whatsapp" style="margin-left:6px;"></i> <?php echo $t; ?></a>
	<?php endforeach; ?>
</div>

<!-- Page Wrapper -->
<div class="hb-page-wrap">

<script>
// Sticky nav scroll effect
window.addEventListener('scroll', function() {
	document.getElementById('hb-nav').classList.toggle('scrolled', window.scrollY > 40);
});
// Mobile toggle
var toggle = document.getElementById('hb-mobile-toggle');
var drawer = document.getElementById('hb-drawer');
var icon   = document.getElementById('hb-toggle-icon');
toggle.addEventListener('click', function() {
	drawer.classList.toggle('active');
	var isOpen = drawer.classList.contains('active');
	icon.className = isOpen ? 'fas fa-times' : 'fas fa-bars';
});
</script>