<?php include_once 'header.php'; ?>

<style>
/* ==============================
   HERO SECTION
============================== */
.hb-hero {
	position: relative;
	overflow: hidden;
	background: linear-gradient(135deg, #0f0e17 0%, #1a1927 40%, #1d1738 100%);
	padding: 90px 0 70px;
	margin-bottom: 60px;
}
.hb-hero::before {
	content: '';
	position: absolute;
	inset: 0;
	background:
		radial-gradient(circle at 20% 50%, rgba(108,99,255,0.18) 0%, transparent 55%),
		radial-gradient(circle at 80% 30%, rgba(247,37,133,0.14) 0%, transparent 50%);
}
.hb-hero-inner {
	max-width: 1280px;
	margin: 0 auto;
	padding: 0 24px;
	display: grid;
	grid-template-columns: 1fr 1fr;
	align-items: center;
	gap: 60px;
	position: relative;
	z-index: 1;
}
.hb-hero-text h1 {
	font-size: clamp(2rem, 4vw, 3.2rem);
	font-weight: 900;
	line-height: 1.25;
	margin-bottom: 20px;
	background: linear-gradient(135deg, #fff 0%, var(--accent) 100%);
	-webkit-background-clip: text;
	-webkit-text-fill-color: transparent;
	background-clip: text;
}
.hb-hero-text p {
	color: var(--text-muted);
	font-size: 1.05rem;
	margin-bottom: 36px;
	max-width: 420px;
}
.hb-hero-btns { display: flex; gap: 14px; flex-wrap: wrap; }
.hb-btn-primary {
	display: inline-flex;
	align-items: center;
	gap: 10px;
	padding: 14px 30px;
	background: linear-gradient(135deg, var(--primary), var(--primary-dark));
	color: #fff;
	border-radius: 14px;
	font-weight: 700;
	font-size: 0.95rem;
	box-shadow: 0 4px 20px rgba(108,99,255,0.4);
	transition: filter var(--transition), transform var(--transition);
}
.hb-btn-primary:hover { filter: brightness(1.15); transform: translateY(-3px); }
.hb-btn-secondary {
	display: inline-flex;
	align-items: center;
	gap: 10px;
	padding: 14px 30px;
	background: var(--surface);
	border: 1px solid var(--border);
	color: var(--text);
	border-radius: 14px;
	font-weight: 700;
	font-size: 0.95rem;
	transition: background var(--transition), transform var(--transition);
}
.hb-btn-secondary:hover { background: var(--surface-hover); transform: translateY(-3px); }
.hb-hero-art {
	display: grid;
	grid-template-columns: 1fr 1fr;
	gap: 16px;
}
.hb-hero-card {
	background: var(--surface);
	border: 1px solid var(--border);
	border-radius: var(--radius);
	aspect-ratio: 1;
	overflow: hidden;
	transition: transform var(--transition);
}
.hb-hero-card:hover { transform: scale(1.04); }
.hb-hero-card:first-child {
	grid-column: span 2;
	aspect-ratio: 16/7;
}
.hb-hero-card img { width: 100%; height: 100%; object-fit: cover; }

/* Floating stats */
.hb-hero-stats {
	display: flex;
	gap: 24px;
	margin-top: 36px;
}
.hb-hero-stat {
	text-align: center;
}
.hb-hero-stat strong {
	display: block;
	font-size: 1.5rem;
	font-weight: 900;
	color: var(--primary);
}
.hb-hero-stat span { font-size: 0.78rem; color: var(--text-muted); }

/* ==============================
   SECTION HEADER
============================== */
.hb-section {
	max-width: 1280px;
	margin: 0 auto;
	padding: 0 24px 80px;
}
.hb-section-header {
	display: flex;
	align-items: flex-end;
	justify-content: space-between;
	margin-bottom: 32px;
	padding-bottom: 16px;
	border-bottom: 1px solid var(--border);
}
.hb-section-title h2 {
	font-size: 1.6rem;
	font-weight: 900;
	position: relative;
	display: inline-block;
}
.hb-section-title h2::after {
	content: '';
	position: absolute;
	bottom: -4px;
	right: 0;
	width: 50%;
	height: 3px;
	background: linear-gradient(90deg, var(--primary), var(--secondary));
	border-radius: 2px;
}
.hb-section-title p { color: var(--text-muted); font-size: 0.9rem; margin-top: 8px; }
.hb-see-all {
	display: inline-flex;
	align-items: center;
	gap: 8px;
	padding: 8px 18px;
	border-radius: 10px;
	border: 1px solid var(--border);
	background: var(--surface);
	font-size: 0.85rem;
	font-weight: 600;
	color: var(--text-muted);
	transition: all var(--transition);
}
.hb-see-all:hover {
	color: var(--primary);
	border-color: var(--primary);
	background: rgba(108,99,255,0.08);
}

/* ==============================
   PRODUCT GRID
============================== */
.hb-products-grid {
	display: grid;
	grid-template-columns: repeat(4, 1fr);
	gap: 20px;
}

/* Product Card */
.hb-product-card {
	background: var(--dark-2);
	border: 1px solid var(--border);
	border-radius: var(--radius);
	overflow: hidden;
	transition: transform var(--transition), box-shadow var(--transition), border-color var(--transition);
	cursor: pointer;
}
.hb-product-card:hover {
	transform: translateY(-6px);
	box-shadow: var(--shadow);
	border-color: rgba(108,99,255,0.35);
}
.hb-product-card a { display: block; color: inherit; }

.hb-product-img-wrap {
	position: relative;
	aspect-ratio: 1;
	overflow: hidden;
	background: var(--dark-3);
}
.hb-product-img-wrap img {
	width: 100%; height: 100%;
	object-fit: cover;
	transition: transform 0.4s ease;
}
.hb-product-card:hover .hb-product-img-wrap img { transform: scale(1.08); }

/* Discount badge */
.hb-discount-badge {
	position: absolute;
	top: 12px;
	right: 12px;
	background: linear-gradient(135deg, var(--secondary), #b5179e);
	color: #fff;
	font-size: 0.72rem;
	font-weight: 800;
	padding: 5px 10px;
	border-radius: 8px;
	letter-spacing: 0.3px;
	box-shadow: 0 2px 10px rgba(247,37,133,0.5);
	text-align: center;
	line-height: 1.3;
	z-index: 1;
}

/* Quick-add overlay */
.hb-product-overlay {
	position: absolute;
	inset: 0;
	background: linear-gradient(to top, rgba(108,99,255,0.85) 0%, transparent 60%);
	display: flex;
	align-items: flex-end;
	justify-content: center;
	padding-bottom: 16px;
	opacity: 0;
	transition: opacity var(--transition);
}
.hb-product-card:hover .hb-product-overlay { opacity: 1; }
.hb-product-overlay span {
	background: #fff;
	color: var(--primary-dark);
	padding: 8px 22px;
	border-radius: 30px;
	font-weight: 700;
	font-size: 0.82rem;
}

.hb-product-info {
	padding: 14px 16px 18px;
}
.hb-product-title {
	font-size: 0.92rem;
	font-weight: 700;
	margin-bottom: 8px;
	color: var(--text);
	display: -webkit-box;
	-webkit-line-clamp: 2;
	-webkit-box-orient: vertical;
	overflow: hidden;
	line-height: 1.45;
}
.hb-product-price {
	display: flex;
	align-items: center;
	gap: 10px;
	flex-wrap: wrap;
}
.hb-price-old {
	font-size: 0.82rem;
	color: var(--text-muted);
	text-decoration: line-through;
}
.hb-price-new {
	font-size: 1.05rem;
	font-weight: 900;
	color: var(--accent);
}
.hb-price-only {
	font-size: 1.05rem;
	font-weight: 900;
	color: var(--text);
}

/* ------------------------------
   Responsive
------------------------------ */
@media (max-width: 1100px) { .hb-products-grid { grid-template-columns: repeat(3, 1fr); } }
@media (max-width: 768px) {
	.hb-hero-inner { grid-template-columns: 1fr; gap: 40px; }
	.hb-hero-art { display: none; }
	.hb-hero-text h1 { font-size: 2rem; }
	.hb-products-grid { grid-template-columns: repeat(2, 1fr); gap: 14px; }
	.hb-section-header { flex-direction: column; align-items: flex-start; gap: 12px; }
}
@media (max-width: 480px) {
	.hb-products-grid { grid-template-columns: repeat(2, 1fr); gap: 10px; }
	.hb-hero { padding: 60px 0 50px; }
}
</style>

<!-- HERO -->
<section class="hb-hero">
	<div class="hb-hero-inner">
		<div class="hb-hero-text">
			<h1>اكتشف أحدث<br>المنتوجات</h1>
			<p>تسوّق من مجموعة واسعة من المنتوجات المختارة بعناية بأفضل الأسعار وتوصيل سريع.</p>
			<div class="hb-hero-btns">
				<a href="<?php echo base_url(); ?>" class="hb-btn-primary">
					<i class="fas fa-fire"></i>
					تسوق الآن
				</a>
				<a href="special/تخفيضات" class="hb-btn-secondary">
					<i class="fas fa-tag"></i>
					التخفيضات
				</a>
			</div>
			<div class="hb-hero-stats">
				<div class="hb-hero-stat">
					<strong><?php echo count($products); ?>+</strong>
					<span>منتوج</span>
				</div>
				<div class="hb-hero-stat">
					<strong>100%</strong>
					<span>أصالة مضمونة</span>
				</div>
				<div class="hb-hero-stat">
					<strong>24h</strong>
					<span>توصيل سريع</span>
				</div>
			</div>
		</div>

		<!-- Decorative product thumbnails -->
		<div class="hb-hero-art">
			<?php $heroProds = array_slice((array)$products, 0, 3); ?>
			<?php foreach($heroProds as $hp): ?>
			<div class="hb-hero-card">
				<img src="uploads/<?php echo add_thumb($hp->images, '_m'); ?>" alt="<?php echo $hp->title; ?>">
			</div>
			<?php endforeach; ?>
		</div>
	</div>
</section>

<!-- PRODUCTS -->
<section class="hb-section">
	<div class="hb-section-header">
		<div class="hb-section-title">
			<h2>جديد</h2>
			<p>أحدث المنتوجات المضافة إلى الموقع</p>
		</div>
		<a href="special/تخفيضات" class="hb-see-all">
			عروض خاصة <i class="fas fa-arrow-left"></i>
		</a>
	</div>

	<div class="hb-products-grid">
		<?php foreach($products as $p) : ?>
		<div class="hb-product-card">
			<a href="<?php echo base_url("home/show/$p->id"); ?>">
				<div class="hb-product-img-wrap">
					<?php if($p->discount != 0): ?>
					<span class="hb-discount-badge"><?php echo $p->discount; ?>%<br>OFF</span>
					<?php endif; ?>
					<img src="uploads/<?php echo add_thumb($p->images, "_m") ?>" alt="<?php echo $p->title; ?>" loading="lazy" />
					<div class="hb-product-overlay">
						<span><i class="fas fa-shopping-bag"></i> إضافة للسلة</span>
					</div>
				</div>
				<div class="hb-product-info">
					<div class="hb-product-title"><?php echo $p->title; ?></div>
					<div class="hb-product-price">
						<?php if($p->discount != 0): ?>
						<span class="hb-price-old"><?php echo $p->price; ?>DH</span>
						<span class="hb-price-new"><?php echo floor($p->price - ($p->price * $p->discount / 100)); ?>DH</span>
						<?php else: ?>
						<span class="hb-price-only"><?php echo $p->price; ?>DH</span>
						<?php endif; ?>
					</div>
				</div>
			</a>
		</div>
		<?php endforeach; ?>
	</div>
</section>

<?php include_once 'footer.php'; ?>